const getCSRFToken = () => {
  return document
    .querySelector('meta[name="csrf-token"]')
    .getAttribute("content");
};

const clubStatusUpdate = () => {
  document.querySelectorAll(".club-btn").forEach((button) => {
    button.addEventListener("click", async () => {
      button.setAttribute("disable", true);
      const csrfToken = getCSRFToken();

      const clubId = button.getAttribute("data-id");
      const action = button.getAttribute("data-action");
      button.innerHTML = `processing...`;
      try {
        const response = await fetch(`/admin/club/status/update/${clubId}`, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            "X-CSRFToken": csrfToken,
          },
          body: JSON.stringify({ action }),
        });

        const result = await response.json();
        if (response.ok) {
          alert(`${result.message}`);
          window.location.href = `/admin/club/details/${clubId}`;
        } else {
          alert(`${result.message}`);
        }
      } catch (error) {
        // console.error("Error:", error);
        alert("Request failed.");
      } finally {
        window.onload();
      }
    });
  });
};
clubStatusUpdate();

const playerStatusUpdate = () => {
  console.log("soem");
  document.querySelectorAll(".player-btn").forEach((button) => {
    button.addEventListener("click", async () => {
      button.setAttribute("disable", true);
      const csrfToken = getCSRFToken();

      const playerId = button.getAttribute("data-id");
      const clubId = button.getAttribute("data-club");
      const action = button.getAttribute("data-action");
      button.innerHTML = `Processing....`;

      try {
        const response = await fetch(
          `/player/club/${clubId}/player/${playerId}/update/`,
          {
            method: "POST",
            headers: {
              "Content-Type": "application/json",
              "X-CSRFToken": csrfToken,
            },
            body: JSON.stringify({ action }),
          }
        );

        const result = await response.json();
        if (response.ok) {
          alert(`${result.message}`);
          window.location.href = `/player/club/${clubId}/player/${playerId}/details/`;
        } else {
          alert(`${result.message}`);
        }
      } catch (error) {
        const msg =
          error instanceof Error
            ? error.message
            : "Apologies, action was not performed.";
        alert(msg);
      } finally {
        window.onload();
      }
    });
  });
};
playerStatusUpdate();
