from datetime import date
from django.db import models
from club.models import Club
from core.models import PublicMediaStorage, Season


class Player(models.Model):
    PLAYER_STATUS_PENDING = 'P'
    PLAYER_STATUS_APPROVED = 'A'
    PLAYER_STATUS_DELETE = 'D'
    PLAYER_STATUS_UNAPPROVED = 'Unapproved'

    PLAYER_STATUS_CHOICES = [
        (PLAYER_STATUS_PENDING, 'Pending'),
        (PLAYER_STATUS_APPROVED, 'Approved'),
        (PLAYER_STATUS_UNAPPROVED, 'Unapproved'),
        (PLAYER_STATUS_DELETE, 'Delete')
    ]


    club = models.ForeignKey(Club, on_delete=models.CASCADE)
    player_id = models.CharField(
        max_length=255, unique=True, null=False, blank=False)
    season = models.ForeignKey(
        Season, on_delete=models.PROTECT)
    reg_year = models.CharField(max_length=204, blank=False)
    status = models.CharField(
        max_length=20, choices=PLAYER_STATUS_CHOICES, default=PLAYER_STATUS_UNAPPROVED)
    rejection_message = models.CharField(max_length=200, blank=True, null=True)
    state_fa = models.CharField(max_length=100)
    surname = models.CharField(max_length=100)
    other_names = models.CharField(max_length=100)
    date_of_birth = models.DateField()
    place_of_birth = models.CharField(max_length=100)
    nationality = models.CharField(max_length=50)
    state_of_origin = models.CharField(max_length=50)
    residential_address = models.TextField()
    permanent_address = models.TextField()
    employer = models.CharField(max_length=100)
    last_club = models.CharField(max_length=100)
    present_club = models.CharField(max_length=100)
    club_division = models.CharField(max_length=50)
    date_left_last_club = models.DateField()
    reason_for_leaving = models.TextField()
    contract_period = models.CharField(max_length=100)
    contract_expiry = models.DateField()
    jersey_number = models.PositiveIntegerField()
    position = models.CharField(max_length=50)
    player_signature = models.ImageField(
        upload_to='signatures/', storage=PublicMediaStorage())
    agent_name = models.CharField(max_length=100, blank=True, null=True)
    agent_signature = models.ImageField(
        upload_to='signatures/', storage=PublicMediaStorage(), blank=True, null=True)
    club_stamp = models.ImageField(
        upload_to='stamps/', storage=PublicMediaStorage())
    passport_photo = models.ImageField(
        upload_to='photos/', storage=PublicMediaStorage())
    date_created = models.DateField(auto_now_add=True)
    updated_at = models.DateField(auto_now=True)
    is_minor = models.BooleanField(default=False)
    parental_consent = models.FileField(
        upload_to='consents/', storage=PublicMediaStorage(), blank=True, null=True
    )

    def __str__(self):
        return f"{self.surname} {self.other_names} - {self.player_id}"
