# Generated by Django 5.2.7 on 2025-11-07 11:01

import core.models
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('club', '0001_initial'),
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Player',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('player_id', models.CharField(max_length=255, unique=True)),
                ('reg_year', models.CharField(max_length=204)),
                ('status', models.CharField(choices=[('P', 'Pending'), ('A', 'Approved'), ('Unapproved', 'Unapproved'), ('D', 'Delete')], default='Unapproved', max_length=20)),
                ('state_fa', models.CharField(max_length=100)),
                ('surname', models.CharField(max_length=100)),
                ('other_names', models.CharField(max_length=100)),
                ('date_of_birth', models.DateField()),
                ('place_of_birth', models.CharField(max_length=100)),
                ('nationality', models.CharField(max_length=50)),
                ('state_of_origin', models.CharField(max_length=50)),
                ('residential_address', models.TextField()),
                ('permanent_address', models.TextField()),
                ('employer', models.CharField(max_length=100)),
                ('last_club', models.CharField(max_length=100)),
                ('present_club', models.CharField(max_length=100)),
                ('club_division', models.CharField(max_length=50)),
                ('date_left_last_club', models.DateField()),
                ('reason_for_leaving', models.TextField()),
                ('contract_period', models.CharField(max_length=100)),
                ('contract_expiry', models.DateField()),
                ('jersey_number', models.PositiveIntegerField()),
                ('position', models.CharField(max_length=50)),
                ('player_signature', models.ImageField(storage=core.models.PublicMediaStorage(), upload_to='signatures/')),
                ('agent_name', models.CharField(blank=True, max_length=100, null=True)),
                ('agent_signature', models.ImageField(blank=True, null=True, storage=core.models.PublicMediaStorage(), upload_to='signatures/')),
                ('club_stamp', models.ImageField(storage=core.models.PublicMediaStorage(), upload_to='stamps/')),
                ('passport_photo', models.ImageField(storage=core.models.PublicMediaStorage(), upload_to='photos/')),
                ('date_created', models.DateField(auto_now_add=True)),
                ('updated_at', models.DateField(auto_now=True)),
                ('is_minor', models.BooleanField(default=False)),
                ('parental_consent', models.FileField(blank=True, null=True, storage=core.models.PublicMediaStorage(), upload_to='consents/')),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='club.club')),
                ('season', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='core.season')),
            ],
        ),
    ]
