from django.db import models
from django.conf import settings
from django.contrib.auth.models import AbstractUser
from storages.backends.s3boto3 import S3Boto3Storage


class PublicMediaStorage(S3Boto3Storage):
    region_name = settings.AWS_S3_REGION_NAME
    bucket_name = settings.AWS_STORAGE_BUCKET_NAME
    file_overwrite = False


class User(AbstractUser):
    email = models.EmailField(unique=True)
    ROLE_CHOICES = (
        ('admin', 'Admin'),
        ('club', 'Club'),
    )

    profile_photo = models.ImageField(
        upload_to='photos/', storage=PublicMediaStorage(), blank=True, null=True)

    club_name = models.CharField(max_length=100, blank=True, null=True)
    club_logo = models.ImageField(
        upload_to='logos/', storage=PublicMediaStorage(), blank=True, null=True)

    role = models.CharField(
        max_length=20, choices=ROLE_CHOICES, default="club", blank=True, null=True)

    is_club_approved = models.BooleanField(default=False)


# Setting up general config for season
class Season(models.Model):
    SEASON_CHOICES = [
        ('first', 'First Season'),
        ('second', 'Second Season'),
        ('third', 'Third Season'),
        ('fourth', 'Fourth Season'),
    ]

    name = models.CharField(
        max_length=20, choices=SEASON_CHOICES, unique=True, default="first")
    registration_start = models.DateField()
    registration_end = models.DateField()
    match_start = models.DateField()
    match_end = models.DateField()
    is_active = models.BooleanField(default=False)

    def __str__(self):
        return f"{self.get_name_display()}"
