from django.conf import settings
from django.db import models
from core.models import PublicMediaStorage, Season



class Club(models.Model):
    CLUB_STATUS_PENDING = 'Pending'
    CLUB_STATUS_APPROVED = 'Approved'
    CLUB_STATUS_DELETE = 'Delete'
    CLUB_STATUS_UNAPPROVED = 'Unapproved'

    CLUB_STATUS_CHOICES = [
        (CLUB_STATUS_PENDING, 'Pending'),
        (CLUB_STATUS_APPROVED, 'Approved'),
        (CLUB_STATUS_UNAPPROVED, 'Unapproved'),
        (CLUB_STATUS_DELETE, 'Delete')
    ]

    user = models.OneToOneField(
        settings.AUTH_USER_MODEL, on_delete=models.PROTECT)
    reg_year = models.CharField(max_length=204, blank=False)
    season = models.ForeignKey(
        Season, on_delete=models.PROTECT)
    status = models.CharField(
        max_length=20, choices=CLUB_STATUS_CHOICES, default=CLUB_STATUS_UNAPPROVED)
    rejection_message = models.CharField(max_length=200, blank=True, null=True)
    club_name = models.CharField(max_length=100)
    division = models.CharField(max_length=50)
    foundation_date = models.DateField()
    state_fa = models.CharField(max_length=100)
    contact_person = models.CharField(max_length=100)
    telephone = models.CharField(max_length=20)
    email = models.EmailField()
    home_venue = models.CharField(max_length=100)
    first_jersey_shirt = models.CharField(max_length=50)
    first_jersey_short = models.CharField(max_length=50)
    first_jersey_hose = models.CharField(max_length=50)
    second_jersey_shirt = models.CharField(max_length=50)
    second_jersey_short = models.CharField(max_length=50)
    second_jersey_hose = models.CharField(max_length=50)
    state_fa_affiliation = models.FileField(
        upload_to='documents/', storage=PublicMediaStorage())
    registration_receipt = models.FileField(
        upload_to='documents/', storage=PublicMediaStorage())
    cac_certificate = models.FileField(
        upload_to='documents/', storage=PublicMediaStorage())
    audited_financials = models.FileField(
        upload_to='documents/', storage=PublicMediaStorage())
    insurance_document = models.FileField(
        upload_to='documents/', storage=PublicMediaStorage())
    stadium_document = models.FileField(
        upload_to='documents/', storage=PublicMediaStorage())
    club_logo = models.ImageField(
        upload_to='logos/', storage=PublicMediaStorage())
    date_created = models.DateField(auto_now_add=True)
    updated_at = models.DateField(auto_now=True)

    def __str__(self):
        return self.club_name


class Official(models.Model):
    club = models.ForeignKey(Club, on_delete=models.CASCADE)
    name = models.CharField(max_length=100)
    designation = models.CharField(max_length=100)
    sex = models.CharField(max_length=10)
    status = models.CharField(max_length=12, default="Unapproved")
    rejection_message = models.CharField(max_length=200, blank=True, null=True)

    is_coach = models.BooleanField(default=False)
    coaching_certificate_obtained = models.CharField(
        max_length=100, blank=True, null=True)
    certificate_year = models.PositiveIntegerField(blank=True, null=True)
    certificate_upload = models.FileField(
        upload_to='documents/', storage=PublicMediaStorage(), blank=True, null=True)
    passport_photo = models.ImageField(
        upload_to='photos/', storage=PublicMediaStorage())
    date_created = models.DateField(auto_now_add=True)
    updated_at = models.DateField(auto_now=True)
    def __str__(self):
        return f"{self.name} - {self.designation}"